#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/bbox.h>

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/test_tools/comparison.h>

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

namespace {

const TString BBOX = "bbox";

} // namespace

BBox BBox::fromYTNode(const NYT::TNode& node) {
    NYT::TNode bboxNode = node[BBOX];
    BBox bbox;
    bbox.geoGeom_ = geolib3::BoundingBox(
        geolib3::Point2(bboxNode[0][0].AsDouble(), bboxNode[0][1].AsDouble()),
        geolib3::Point2(bboxNode[1][0].AsDouble(), bboxNode[1][1].AsDouble())
    );
    return bbox;
}

NYT::TNode BBox::toYTNode() const {
    NYT::TNode node;
    toYTNode(node);
    return node;
}

void BBox::toYTNode(NYT::TNode& node) const {
    node[BBOX] = NYT::TNode::CreateList()
        .Add(NYT::TNode::CreateList()
            .Add(geoGeom_.minX())
            .Add(geoGeom_.minY()))
        .Add(NYT::TNode::CreateList()
            .Add(geoGeom_.maxX())
            .Add(geoGeom_.maxY()));
}

bool BBox::operator==(const BBox& that) const {
    return geolib3::test_tools::approximateEqual(geoGeom_, that.geoGeom_, geolib3::EPS);
}

} // namespace maps::wiki::autocart::pipeline
