#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/dwellplace.h>

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/test_tools/comparison.h>

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

namespace {

static const TString LATITUDE = "Latitude";
static const TString LONGITUDE = "Longitude";

}

Dwellplace Dwellplace::fromYTNode(const NYT::TNode& node) {
    Dwellplace place;
    place.geoGeom_ = geolib3::Point2(
        node[LONGITUDE].AsDouble(),
        node[LATITUDE].AsDouble()
    );
    return place;
}

NYT::TNode Dwellplace::toYTNode() const {
    NYT::TNode node;
    toYTNode(node);
    return node;
}

void Dwellplace::toYTNode(NYT::TNode& node) const {
    node[LONGITUDE] = geoGeom_.x();
    node[LATITUDE] = geoGeom_.y();
}

bool Dwellplace::operator==(const Dwellplace& that) const {
    return geolib3::test_tools::approximateEqual(geoGeom_, that.geoGeom_, geolib3::EPS);
}

} // namespace maps::wiki::autocart::pipeline
