#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/ft_type_id.h>

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::autocart::pipeline {

FTTypeId decodeFTTypeId(int value) {
    switch(value) {
#define CODE_TO_FT_TYPE_ID(enum_name, code, ru_name, compatibility) \
    case code:                                       \
        return FTTypeId::enum_name;
        FT_TYPE_ID_LIST(CODE_TO_FT_TYPE_ID)
#undef CODE_TO_FT_TYPE_ID
        default:
            throw maps::RuntimeError("Invalid ft_type_id: " + std::to_string(value));
    }
}

int encodeFTTypeId(const FTTypeId& ftTypeId) {
    switch(ftTypeId) {
#define FT_TYPE_ID_TO_CODE(enum_name, code, ru_name, compatibility) \
    case FTTypeId::enum_name:                        \
        return code;
        FT_TYPE_ID_LIST(FT_TYPE_ID_TO_CODE)
#undef FT_TYPE_ID_TO_CODE
    }
}

std::string ruNameFTTypeId(const FTTypeId& ftTypeId) {
    switch(ftTypeId) {
#define FT_TYPE_ID_TO_RU_NAME(enum_name, code, ru_name, compatibility) \
    case FTTypeId::enum_name:                           \
        return ru_name;
        FT_TYPE_ID_LIST(FT_TYPE_ID_TO_RU_NAME)
#undef FT_TYPE_ID_TO_RU_NAME
    }
}

FTTypeIdCompatibility compatibilityFTTypeId(const FTTypeId& ftTypeId) {
    switch(ftTypeId) {
#define FT_TYPE_ID_TO_COMPATIBILITY(enum_name, code, ru_name, compatibility) \
    case FTTypeId::enum_name:                           \
        return compatibility;
        FT_TYPE_ID_LIST(FT_TYPE_ID_TO_COMPATIBILITY)
#undef FT_TYPE_ID_TO_COMPATIBILITY
    }
}

bool isCompatibleWithBld(const FTTypeId& ftTypeId) {
    FTTypeIdCompatibility compatibility = compatibilityFTTypeId(ftTypeId);
    return compatibility == FTTypeIdCompatibility::ALL
        || compatibility == FTTypeIdCompatibility::BLD;
}

bool isCompatibleWithArea(const FTTypeId& ftTypeId) {
    FTTypeIdCompatibility compatibility = compatibilityFTTypeId(ftTypeId);
    return compatibility == FTTypeIdCompatibility::ALL
        || compatibility == FTTypeIdCompatibility::AREA;
}

} // namespace maps::wiki::autocart::pipeline
