#pragma once

#include <maps/libs/geolib/include/multipolygon.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/base_object.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/ft_type_id.h>

#include <mapreduce/yt/interface/client.h>

#include <optional>

namespace maps::wiki::autocart::pipeline {

class Area : public BaseObject<geolib3::MultiPolygon2, Area> {
public:
    static Area fromYTNode(const NYT::TNode& node);

    NYT::TNode toYTNode() const;
    void toYTNode(NYT::TNode& node) const;

    bool hasFTTypeId() const;

    void setFTTypeId(const FTTypeId& ftTypeId);

    // get methods throw exception if parameters are not defined
    FTTypeId getFTTypeId() const;

    bool operator==(const Area& that) const;

private:
    std::optional<FTTypeId> ftTypeId_;
};

std::vector<Area> areasFromYTNode(const NYT::TNode& node);

void areasToYTNode(const std::vector<Area>& areas, NYT::TNode& node);

} // namespace maps::wiki::autocart::pipeline
