#pragma once

#include <maps/libs/geolib/include/conversion.h>

namespace maps::wiki::autocart::pipeline {

template <class Geom, class Object>
class BaseObject {
public:
    using GeomType = Geom;

    static Object fromMercatorGeom(const GeomType& geom) {
        Object object;
        object.geoGeom_ = geolib3::convertMercatorToGeodetic(geom);
        return object;
    }
    static Object fromGeodeticGeom(const GeomType& geom) {
        Object object;
        object.geoGeom_ = geom;
        return object;
    }

    GeomType toMercatorGeom() const {
        return geolib3::convertGeodeticToMercator(geoGeom_);
    }

    const GeomType& toGeodeticGeom() const {
        return geoGeom_;
    }

protected:
    GeomType geoGeom_;
};

} // namespace maps::wiki::autocart::pipeline
