#pragma once

#include <maps/libs/geolib/include/polygon.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/base_object.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/ft_type_id.h>

#include <maps/libs/json/include/value.h>
#include <maps/libs/json/include/builder.h>

#include <mapreduce/yt/interface/client.h>

#include <optional>

namespace maps::wiki::autocart::pipeline {

class Building : public BaseObject<geolib3::Polygon2, Building> {
public:
    static constexpr const char* BLD_ID = "bld_id";

    static Building fromYTNode(const NYT::TNode& node);
    static Building fromJson(const json::Value& value);

    NYT::TNode toYTNode() const;
    void toYTNode(NYT::TNode& node) const;
    void toJson(json::ObjectBuilder& builder) const;

    bool hasId() const;
    bool hasHeight() const;
    bool hasFTTypeId() const;

    void setId(int64_t id);
    void setHeight(int height);
    void setFTTypeId(const FTTypeId& ftTypeId);

    // get methods throw exception if parameters are not defined
    int64_t getId() const;
    int getHeight() const;
    FTTypeId getFTTypeId() const;

    bool operator==(const Building& that) const;

private:
    std::optional<int64_t> id_;
    std::optional<int> height_;
    std::optional<FTTypeId> ftTypeId_;
};

std::vector<Building> bldsFromYTNode(const NYT::TNode& node);

void bldsToYTNode(const std::vector<Building>& blds, NYT::TNode& node);

} // namespace maps::wiki::autocart::pipeline
