#pragma once

#include <vector>
#include <string>

namespace maps::wiki::autocart::pipeline {

enum class FTTypeIdCompatibility {
    BLD = 1,
    AREA = 2,
    ALL = 3
};

// see YMapsDF docs for bld:ft_type_id
// https://doc.yandex-team.ru/ymaps/ymapsdf/ymapsdf-ref/concepts/bld.html
// https://doc.yandex-team.ru/ymaps/ymapsdf/ymapsdf-ref/concepts/ft.html
#define FT_TYPE_ID_LIST(V)                                                                       \
    V(URBAN_RESIDENTIAL, 101, "жилой", FTTypeIdCompatibility::ALL)                             \
    V(URBAN_INDUSTRIAL, 102, "промышленный", FTTypeIdCompatibility::ALL)                       \
    V(URBAN_GOV, 103, "муниципальное, государственное учреждение", FTTypeIdCompatibility::ALL) \
    V(URBAN_PUBLIC, 104, "общественный", FTTypeIdCompatibility::ALL)                           \
    V(URBAN_BUSINESS_CENTER, 105, "бизнес-центр", FTTypeIdCompatibility::ALL)                  \
    V(URBAN_STRUCTURE, 106, "сооружение, некапитальная постройка", FTTypeIdCompatibility::BLD) \
    V(URBAN_RELIGION_WORSHIP, 114, "религиозное учреждение", FTTypeIdCompatibility::ALL)       \
    V(URBAN_EDU, 171, "образовательное учреждение", FTTypeIdCompatibility::ALL)                \
    V(URBAN_MED, 172, "медицинское учреждение", FTTypeIdCompatibility::ALL)                    \
    V(URBAN_SHOPPING, 173, "магазин", FTTypeIdCompatibility::ALL)                              \
    V(URBAN_SPORT, 191, "спортивный объект", FTTypeIdCompatibility::ALL)                       \
    V(URBAN_LEISURE, 222, "культурно-развлекательное учреждение", FTTypeIdCompatibility::BLD)  \
    V(URBAN_TRANSPORT, 261, "транспортное сооружение", FTTypeIdCompatibility::ALL)             \
    V(URBAN_UNDER_CONSTRUCTION, 151, "стройплощадка", FTTypeIdCompatibility::AREA)

enum class FTTypeId {
#define DECLARE_ENUM(enum_name, code, ru_name, compatibility) enum_name,
    FT_TYPE_ID_LIST(DECLARE_ENUM)
#undef DECLARE_ENUM
};

static const std::vector<FTTypeId> ALL_FT_TYPE_ID{
#define DECLARE_VECTOR(enum_name, code, ru_name, compatibility) \
    FTTypeId::enum_name,
    FT_TYPE_ID_LIST(DECLARE_VECTOR)
#undef DECLARE_VECTOR
};

FTTypeId decodeFTTypeId(int value);

int encodeFTTypeId(const FTTypeId& ftTypeId);

std::string ruNameFTTypeId(const FTTypeId& ftTypeId);

FTTypeIdCompatibility compatibilityFTTypeId(const FTTypeId& ftTypeId);

bool isCompatibleWithBld(const FTTypeId& ftTypeId);

bool isCompatibleWithArea(const FTTypeId& ftTypeId);

} // namespace maps::wiki::autocart::pipeline
