#pragma once

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/base_object.h>

#include <maps/libs/geolib/include/polyline.h>

#include <mapreduce/yt/interface/client.h>

#include <optional>

namespace maps::wiki::autocart::pipeline {

class Road : public BaseObject<geolib3::Polyline2, Road> {
public:
    static Road fromYTNode(const NYT::TNode& node);

    NYT::TNode toYTNode() const;
    void toYTNode(NYT::TNode& node) const;

    bool operator==(const Road& that) const;

    bool hasFc() const;
    bool hasFow() const;

    void setFc(int64_t);
    void setFow(int64_t);

    // get methods throw exception if parameters are not defined
    int64_t getFc() const;
    int64_t getFow() const;

private:
    std::optional<int64_t> fc_;
    std::optional<int64_t> fow_;
};

std::vector<Road> roadsFromYTNode(const NYT::TNode& node);

void roadsToYTNode(const std::vector<Road>& roads, NYT::TNode& node);

} // namespace maps::wiki::autocart::pipeline
