#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/building.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/base_results.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/strings.h>

namespace maps::wiki::autocart::pipeline {

// Base results

void BaseResult::toJson(json::ObjectBuilder& builder) const {
    bld.toJson(builder);
    builder[RESULT_ID] = id;
}

BaseResult BaseResult::fromJson(const json::Value& value) {
    BaseResult result;
    result.id = value[RESULT_ID].as<uint64_t>();
    result.bld = Building::fromJson(value);
    return result;
}

bool BaseResult::operator==(const BaseResult& that) const {
    return id == that.id
        && bld == that.bld;
}

} // namespace maps::wiki::autocart::pipeline
