#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/building.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/detection_results.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/storage/include/strings.h>

namespace maps::wiki::autocart::pipeline {

namespace {

constexpr const char* STATE = "state";
constexpr const char* CONFIDENCE = "confidence";

} // namespace

// Detection results

const std::string& DetectionResult::getName() {
    static const std::string NAME = "detection";
    return NAME;
}

NYT::TNode DetectionResult::toYTNode() const {
    NYT::TNode node = bld.toYTNode();
    node[RESULT_ID] = id;
    node[STATE] = TString(toString(state));
    node[CONFIDENCE] = confidence;
    return node;
}

void DetectionResult::toJson(json::ObjectBuilder& builder) const {
    bld.toJson(builder);
    builder[RESULT_ID] = id;
    builder[STATE] = toString(state);
    builder[CONFIDENCE] = confidence;
}

DetectionResult DetectionResult::fromYTNode(const NYT::TNode& node) {
    DetectionResult result;
    result.id = node[RESULT_ID].AsUint64();
    result.bld = Building::fromYTNode(node);
    fromString(node[STATE].AsString().data(), result.state);
    result.confidence = node[CONFIDENCE].AsDouble();
    return result;
}

DetectionResult DetectionResult::fromJson(const json::Value& value) {
    DetectionResult result;
    result.id = value[RESULT_ID].as<uint64_t>();
    result.bld = Building::fromJson(value);
    fromString(value[STATE].as<std::string>(), result.state);
    result.confidence = value[CONFIDENCE].as<double>();
    return result;
}

NYT::TTableSchema DetectionResult::getTableSchema() {
    return NYT::TTableSchema()
        .AddColumn(REGION, NYT::EValueType::VT_STRING, NYT::ESortOrder::SO_ASCENDING)
        .AddColumn(ISSUE_ID, NYT::EValueType::VT_UINT64, NYT::ESortOrder::SO_ASCENDING)
        .AddColumn(RESULT_ID, NYT::EValueType::VT_UINT64)
        .AddColumn(CONFIDENCE, NYT::EValueType::VT_DOUBLE)
        .AddColumn(STATE, NYT::EValueType::VT_STRING)
        .AddColumn(DUMP_DATE, NYT::EValueType::VT_STRING)
        .Strict(false);
}

bool DetectionResult::operator==(const DetectionResult& that) const {
    return id == that.id
        && bld == that.bld
        && state == that.state
        && confidence == that.confidence;
}

} // namespace maps::wiki::autocart::pipeline
