#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/json/include/builder.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/toloka/include/states.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/building.h>

#include <optional>

namespace maps::wiki::autocart::pipeline {

struct AssessorsResult {
public:
    static const std::string& getName();

    NYT::TNode toYTNode() const;
    void toJson(json::ObjectBuilder& builder) const;
    static AssessorsResult fromYTNode(const NYT::TNode& node);
    static AssessorsResult fromJson(const json::Value& value);

    static NYT::TTableSchema getTableSchema();

    bool operator==(const AssessorsResult& that) const;

    uint64_t id;
    Building bld;
    TolokaState state;
    std::string assessorId;
    std::string taskId;
    std::optional<std::string> login;
};

} // namespace maps::wiki::autocart::pipeline
