#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <maps/libs/json/include/value.h>
#include <maps/libs/json/include/builder.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/toloka/include/states.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/building.h>

#include <unordered_map>

namespace maps::wiki::autocart::pipeline {

class DetectionResult {
public:
    static const std::string& getName();

    NYT::TNode toYTNode() const;
    void toJson(json::ObjectBuilder& builder) const;
    static DetectionResult fromYTNode(const NYT::TNode& node);
    static DetectionResult fromJson(const json::Value& value);

    static NYT::TTableSchema getTableSchema();

    bool operator==(const DetectionResult& that) const;

    uint64_t id;
    Building bld;
    TolokaState state;
    double confidence;
};

} // namespace maps::wiki::autocart::pipeline
