#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/json/include/builder.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/building.h>

namespace maps::wiki::autocart::pipeline {

enum class PublicationStatus {
    Published,
    Intersects,
    Error
};

PublicationStatus decodePublicationStatus(int value);

int encodePublicationStatus(const PublicationStatus& status);

struct PublicationResult {
public:
    static const std::string& getName();

    NYT::TNode toYTNode() const;
    void toJson(json::ObjectBuilder& builder) const;
    static PublicationResult fromYTNode(const NYT::TNode& node);
    static PublicationResult fromJson(const json::Value& value);

    static NYT::TTableSchema getTableSchema();

    bool operator==(const PublicationResult& that) const;

    uint64_t id;
    Building bld;
    PublicationStatus status;
};

} // namespace maps::wiki::autocart::pipeline
