#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/json/include/builder.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/toloka/include/states.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/objects/include/building.h>

#include <vector>
#include <utility>

namespace maps::wiki::autocart::pipeline {

class TolokersResult {
public:
    static const std::string& getName();

    NYT::TNode toYTNode() const;
    void toJson(json::ObjectBuilder& builder) const;
    static TolokersResult fromYTNode(const NYT::TNode& node);
    static TolokersResult fromJson(const json::Value& value);

    static NYT::TTableSchema getTableSchema();

    bool operator==(const TolokersResult& that) const;

    uint64_t id;
    Building bld;
    std::vector<std::pair<std::string, TolokaState>> userStates;
    TolokaState state;
    std::string taskId;
};

} // namespace maps::wiki::autocart::pipeline
