#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/toloka/include/utils.h>

#include <maps/libs/common/include/exception.h>

#include <util/string/split.h>
#include <util/string/cast.h>

namespace maps::wiki::autocart::pipeline {

namespace {

int64_t extractBldIdImpl(
    const std::string& str,
    const std::string& prefix, const std::string& postfix)
{
    size_t pos = str.find(prefix);
    REQUIRE(pos != std::string::npos, "Invalid string format: " << str);
    size_t start = pos + prefix.size();
    size_t end = str.find(postfix, start);
    if (end == std::string::npos) {
        return FromString<int64_t>(str.substr(start));
    } else {
        return FromString<int64_t>(str.substr(start, end - start));
    }
}

// Извлекаем id здания из url
// Пример url:
//   https://npro.maps.yandex.ru/#!/objects/101746877?z=20&ll=39.773814%2C47.250930&l=nk%23sat
int64_t extractBldIdFromNPRO(const http::URL& url) {
    static const std::string PREFIX = "objects/";
    static const std::string POSTFIX = "?";

    return extractBldIdImpl(url.fragment(), PREFIX, POSTFIX);
}

// Извлекаем id здания из url
// Пример url:
//   https://n.maps.yandex.ru/#!/objects/774138315?z=20&ll=73.289085%2C55.029070&l=nk%23sat
int64_t extractBldIdFromNMaps(const http::URL& url) {
    static const std::string PREFIX = "objects/";
    static const std::string POSTFIX = "?";

    return extractBldIdImpl(url.fragment(), PREFIX, POSTFIX);
}

// Извлекаем id здания из url
// Пример url:
//   https://mpro.maps.yandex.ru/?ll=46.103494%2C43.347648&z=19&id=1544972247
int64_t extractBldIdFromMPRO(const http::URL& url) {
    static const std::string PREFIX = "id=";
    static const std::string POSTFIX = "&";

    return extractBldIdImpl(url.params(), PREFIX, POSTFIX);
}

} // namespace

// Извлекаем id здания из url
int64_t extractBldId(const http::URL& url) {
    if (url.host() == "npro.maps.yandex.ru") {
        return extractBldIdFromNPRO(url);
    } else if (url.host() == "mpro.maps.yandex.ru") {
        return extractBldIdFromMPRO(url);
    } else if (url.host() == "n.maps.yandex.ru") {
        return extractBldIdFromNMaps(url);
    } else {
        throw maps::RuntimeError() << "Unknown host: " << url;
    }
}

} // namespace maps::wiki::autocart::pipeline
