#pragma once

#include <string>
#include <vector>
#include <map>

namespace maps::wiki::autocart::pipeline {

using WikiTableRow = std::map<std::string, std::string>;

using WikiTable = std::vector<WikiTableRow>;

// see https://auth.yandex-team.ru for OAuth token
// table name example:
//     URL - https://wiki.yandex-team.ru/users/dolotov-e/Arkadija/
//     name - users/dolotov-e/Arkadija
WikiTable loadWikiTable(const std::string& name, const std::string& oauthToken);

} // namespace maps::wiki::autocart::pipeline
