#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/yt_utils/include/batch.h>
#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/yt_utils/include/rows_count.h>

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

void processBatches(
    NYT::IClientBasePtr client,
    const TString& inputYTTablePath,
    ProcessBatchFunc&& processBatch,
    const TString& outputYTTablePath,
    size_t batchSize,
    EraseBatch mode)
{
    NYT::TRichYPath outputRYTPath(outputYTTablePath);
    outputRYTPath.Append(true);

    client->Create(
        outputRYTPath.Path_,
        NYT::NT_TABLE,
        NYT::TCreateOptions().Recursive(true).Force(true)
    );

    size_t rowsCount = getRowsCount(client, inputYTTablePath);
    if (mode == EraseBatch::No) {
        for (size_t begin = 0; begin < rowsCount; begin += batchSize) {
            size_t end = std::min(begin + batchSize, rowsCount);
            NYT::TRichYPath batchRYTPath(inputYTTablePath);
            batchRYTPath.AddRange(NYT::TReadRange().FromRowIndices(begin, end));
            processBatch(client, batchRYTPath, outputRYTPath);
        }
    } else {
        while(rowsCount > 0) {
            size_t end = std::min(batchSize, rowsCount);
            NYT::TRichYPath batchRYTPath(inputYTTablePath);
            batchRYTPath.AddRange(NYT::TReadRange().FromRowIndices(0, end));
            NYT::ITransactionPtr txn = client->StartTransaction();
            processBatch(txn, batchRYTPath, outputRYTPath);
            txn->Erase(NYT::TEraseOperationSpec().TablePath(batchRYTPath));
            txn->Commit();
            rowsCount = getRowsCount(client, inputYTTablePath);
        }
    }
}

} // namespace maps::wiki::autocart::pipeline
