#include <maps/libs/common/include/exception.h>

#include <maps/wikimap/mapspro/services/autocart/pipeline/libs/yt_utils/include/rows_count.h>

#include <mapreduce/yt/interface/client.h>

namespace maps::wiki::autocart::pipeline {

size_t getRowsCount(const NYT::IClientBasePtr client, const NYT::TYPath& tableYTPath) {
    return client->Get(tableYTPath + "/@row_count").AsInt64();
}

size_t getRowsCount(const NYT::TRichYPath& path) {
    const std::vector<NYT::TReadRange>& ranges = path.Ranges_;
    REQUIRE(ranges.size() == 1u, "There can be only one read range");
    const NYT::TReadRange& range = ranges.front();
    REQUIRE(
        range.UpperLimit_.RowIndex_.Defined() &&
        range.LowerLimit_.RowIndex_.Defined(),
        "Rows limit is undefied"
    );
    return range.UpperLimit_.RowIndex_.GetRef() - range.LowerLimit_.RowIndex_.GetRef();
}

} // namespace maps::wiki::autocart::pipeline
