#pragma once

#include <mapreduce/yt/interface/client.h>

#include <functional>

namespace maps::wiki::autocart::pipeline {

enum class EraseBatch {
    Yes,
    No
};

using ProcessBatchFunc
    = std::function<
        void(NYT::IClientBasePtr, const NYT::TRichYPath&, const NYT::TRichYPath&)>;

void processBatches(
    NYT::IClientBasePtr client,
    const TString& inputYTTablePath,
    ProcessBatchFunc&& processBatch,
    const TString& outputYTTablePath,
    size_t batchSize,
    EraseBatch mode = EraseBatch::No);

} // namespace maps::wiki::autocart::pipeline
