#pragma once

#include <maps/libs/common/include/exception.h>

#include <mapreduce/yt/interface/client.h>

#include <utility>

#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>

namespace maps::wiki::autocart::pipeline {

enum class Operation {
    MAPPER,
    REDUCER
};

class YTOpExecutor {
public:
    class MapSpec {
    public:
        MapSpec& AddInput(const NYT::TRichYPath& value);
        MapSpec& AddOutput(const NYT::TRichYPath& value);

        operator NYT::TMapOperationSpec() const;

    private:
        std::vector<NYT::TRichYPath> inputs_;
        std::vector<NYT::TRichYPath> outputs_;
    };

    class ReduceSpec {
    public:
        ReduceSpec& AddInput(const NYT::TRichYPath& value);
        ReduceSpec& AddOutput(const NYT::TRichYPath& value);
        ReduceSpec& ReduceBy(const NYT::TSortColumns& columns);

        operator NYT::TReduceOperationSpec() const;

    private:
        std::vector<NYT::TRichYPath> inputs_;
        std::vector<NYT::TRichYPath> outputs_;
        NYT::TSortColumns columns_;
    };

    class Options {
    public:
        Options();

        Options& RunningJobCount(uint64_t count);
        Options& JobCount(uint64_t count);
        Options& MemoryLimit(uint64_t limit);
        Options& UseGPU(uint64_t limit);
        Options& Title(const TString& title);
        Options& MaxRowWeight(uint64_t limit);

    private:
        uint64_t runningJobCount_;
        uint64_t jobCount_;
        uint64_t memoryLimit_;
        uint64_t gpuLimit_;
        TString title_;
        uint64_t maxRowWeight_;

        friend class YTOpExecutor;
    };

    static void Map(
        NYT::IClientBasePtr client,
        const MapSpec& spec,
        ::TIntrusivePtr<NYT::IMapperBase> mapper,
        const YTOpExecutor::Options& options = YTOpExecutor::Options());

    static void Reduce(
        NYT::IClientBasePtr client,
        const YTOpExecutor::ReduceSpec& spec,
        ::TIntrusivePtr<NYT::IReducerBase> reducer,
        const YTOpExecutor::Options& options = YTOpExecutor::Options());

    static void Initialize(mrc::yt::PoolType poolType, bool useGPU);

private:
    static NYT::TOperationOptions ToYTOperationOptions(
        const YTOpExecutor::Options& options, const Operation& op);

    static std::optional<mrc::yt::PoolType> POOL_TYPE;
    static bool USE_GPU;
};

} // namespace maps::wiki::autocart::pipeline
