exports.Task = extend(TolokaHandlebarsTask, function (options) {
  this._inputs = options.task.input_values;

  TolokaHandlebarsTask.call(this, options);
}, {
    validate: function (solution) {
        var output = solution.output_values;
        if (!output.state) {
            return {
                task_id: this.getTask().id,
                errors: {
                    state: {
                        code: 'NOT_ALLOWED',
                        message: 'Необходимо классифицировать изображение!'
                    }
                }
            };
        } else if (output.state == "yes"){
            if (!output.ft_type_id) {
                return {
                    task_id: this.getTask().id,
                    errors: {
                        ft_type_id: {
                            code: 'NOT_ALLOWED',
                            message: 'Необходимо определить тип здания!'
                        }
                    }
                };
            }
            if (!output.height) {
                return {
                    task_id: this.getTask().id,
                    errors: {
                        height: {
                            code: 'NOT_ALLOWED',
                            message: 'Необходимо определить высоту здания!'
                        }
                    }
                };
            } else if (!isCorrectHeight(output.height)) {
                return {
                    task_id: this.getTask().id,
                    errors: {
                        height: {
                            code: 'NOT_ALLOWED',
                            message: 'Некорректное значение высоты здания!'
                        }
                    }
                };
            }
        }
        return null;
    },

    onValidationFail: function (data) {
        TolokaHandlebarsTask.prototype.onValidationFail.apply(this, arguments);
    },
    onRender: function() {
        var coordinates = $(this.getDOMElement()).find('.coordinates');
        var polygon = this._inputs.shape;
        coordinates[0].textContent += polygon[0][1] + ", " + polygon[0][0];
        coordinates[0].href += polygon[0][0] + ", " + polygon[0][1];

        var attributes = $(this.getDOMElement()).find('.attributes')[0];

        var showAttributes = function() {
          attributes.style.display = 'block'
        }
        var hideAttributes = function() {
          attributes.style.display = 'none'
        }

        var output_values = this.getSolution().output_values
        if (output_values.state) {
          if (output_values.state == 'yes') {
            showAttributes(); 
          } else {
            hideAttributes();
          }
        }

        var yesRadio = $(this.getDOMElement()).find('.yes')[0];
        yesRadio.onclick = showAttributes
        var noRadio = $(this.getDOMElement()).find('.no')[0];
        noRadio.onclick = hideAttributes
        var notloadedRadio = $(this.getDOMElement()).find('.not-loaded')[0];
        notloadedRadio.onclick = hideAttributes
    }
});

function isCorrectHeight(str) {
    var n = Math.floor(Number(str));
    return n !== Infinity && String(n) === str && n >= 0;
}

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
