exports.Task = extend(TolokaHandlebarsTask, function (options) {
  this._inputs = options.task.input_values;

  TolokaHandlebarsTask.call(this, options);
}, {
    validate: function (solution) {
        var output = solution.output_values;
        if (output.state) {
            return null;
        }

        return {
            task_id: this.getTask().id,
            errors: {
                state: {
                    code: 'NOT_ALLOWED',
                    message: 'Необходимо классифицировать изображение!'
                }
            }
        };
    },

    onValidationFail: function (data) {
        TolokaHandlebarsTask.prototype.onValidationFail.apply(this, arguments);
    },
    onRender: function() {
        var coordinates = $(this.getDOMElement()).find('.coordinates');
        var polygon = this._inputs.shape;
        coordinates[0].textContent += polygon[0][1] + ", " + polygon[0][0];
        coordinates[0].href += polygon[0][0] + ", " + polygon[0][1];
    }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
