#########################################################
#                      Settings                         #
#########################################################
OS=ubuntu1604
TF_VERSION=1.10.1
NVIDIA_REPO="http://developer.download.nvidia.com/compute/cuda/repos/${OS}/x86_64"
NVIDIA_VERSION=418.67-0
NVIDIA_VERSION_MAJOR=${NVIDIA_VERSION%.*} # a.b-c -> a
NVIDIA_PACKAGE="nvidia-${NVIDIA_VERSION_MAJOR}_${NVIDIA_VERSION}ubuntu1_amd64.deb"
CUDA_VERSION=9.0.176-1
CUDA_VERSION_MAJOR_MINOR=${CUDA_VERSION%.*} # a.b.c-d -> a.b
CUDA_VERSION_CODE=${CUDA_VERSION_MAJOR_MINOR//./-} # a.b -> a-b
CUDA_PACKAGES=(
    "cuda-license-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "libcuda1-${NVIDIA_VERSION_MAJOR}_${NVIDIA_VERSION}ubuntu1_amd64.deb"
    "cuda-cufft-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "cuda-cublas-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "cuda-cudart-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "cuda-cusolver-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "cuda-curand-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
)
CUDNN_REPO=http://developer.download.nvidia.com/compute/machine-learning/repos/${OS}/x86_64
CUDNN_VERSION=7.0.5.15-1
PROTOBUF_REPO=https://github.com/google/protobuf/releases/download
PROTOBUF_VERSION=3.6.1

#########################################################
#           Do not wait keyboard input                  #
#########################################################
export DEBIAN_FRONTEND=noninteractive

#########################################################
#                      Update                           #
#########################################################
apt-get update

#########################################################
#                 Install Python3                       #
#########################################################
apt-get --yes --force-yes install python3
apt-get --yes --force-yes install python3-dev
apt-get --yes --force-yes install python3-setuptools
apt-get --yes --force-yes install python3-wheel
easy_install3 -U pip

#########################################################
#                 Install opencv-python                 #
#########################################################
apt-get --yes --force-yes install libfontconfig1
apt-get --yes --force-yes install libxrender1
pip3 install --upgrade opencv-python

#########################################################
#             Install additional python libs            #
#########################################################
pip3 install --upgrade Cython
pip3 install --upgrade contextlib2
pip3 install --upgrade pillow
pip3 install --upgrade lxml
pip3 install --upgrade jupyter
pip3 install --upgrade matplotlib
pip3 install --upgrade numpy
pip3 install --upgrade pandas

#########################################################
#                 Install NVIDIA drivers                #
#########################################################
mkdir /usr/lib/nvidia
wget --quiet ${NVIDIA_REPO}/${NVIDIA_PACKAGE}
apt install --yes --fix-broken --no-install-recommends ./$NVIDIA_PACKAGE
rm -f $NVIDIA_PACKAGE

#########################################################
#                     Install CUDA                      #
#########################################################
for PACKAGE in ${CUDA_PACKAGES[*]}
do
    wget --quiet ${NVIDIA_REPO}/${PACKAGE}
    apt install --yes --fix-broken --no-install-recommends ./$PACKAGE
    rm -f $PACKAGE
done;

#########################################################
#                 Create CUDA symlimk                   #
#########################################################
ln -s /usr/local/cuda-${CUDA_VERSION_MAJOR_MINOR} /usr/local/cuda

#########################################################
#                      Install cuDNN                    #
#########################################################
wget --quiet ${CUDNN_REPO}/nvidia-machine-learning-repo-${OS}_1.0.0-1_amd64.deb
dpkg -i nvidia-machine-learning-repo-${OS}_1.0.0-1_amd64.deb
apt-get update
apt-get install --yes --fix-broken --no-install-recommends libcudnn7=${CUDNN_VERSION}+cuda${CUDA_VERSION_MAJOR_MINOR}
rm -f nvidia-machine-learning-repo-${OS}_1.0.0-1_amd64.deb

#########################################################
#                Configure dynamic linker               #
#########################################################
CUDA_CONF=/etc/ld.so.conf.d/cuda-${CUDA_VERSION_MAJOR_MINOR}.conf
echo /usr/local/cuda-${CUDA_VERSION_MAJOR_MINOR}/lib64 > "${CUDA_CONF}"
echo /usr/lib/x86_64-linux-gnu >> "${CUDA_CONF}"

NVIDIA_CONF=/etc/ld.so.conf.d/nvidia-${NVIDIA_VERSION_MAJOR}.conf
echo /usr/lib/nvidia-${NVIDIA_VERSION_MAJOR} > "${NVIDIA_CONF}"

ldconfig

#########################################################
#                   Install TensorFlow                  #
#########################################################
pip3 install --upgrade tensorflow-gpu==${TF_VERSION}

#########################################################
#                 Default Python3                       #
#                   !!WARNING!!                         #
#     Script to build cocoapi library calls python      #
#   with command `python` but it requires python 3.*    #
#########################################################
update-alternatives --install /usr/bin/python python /usr/bin/python2.7 1
update-alternatives --install /usr/bin/python python /usr/bin/python3.5 2
update-alternatives --set python /usr/bin/python3.5

########################################################
#                   Build coco tools                   #
########################################################
apt-get --yes --force-yes install git
git clone https://github.com/cocodataset/cocoapi.git
cd cocoapi/PythonAPI
make
cd ../..

#########################################################
#                 Default Python2                       #
#                   !!WARNING!!                         #
#   Operation in Nirvana does not start successfully    #
#      if the python 3.* is selected by default         #
#########################################################
update-alternatives --set python /usr/bin/python2.7

#######################################################
#               Install protobuf compiler             #
########################################################
apt-get --yes --force-yes install libzmq-dev
apt-get --yes --force-yes install g++
wget --quiet ${PROTOBUF_REPO}/v${PROTOBUF_VERSION}/protobuf-all-${PROTOBUF_VERSION}.tar.gz
tar -xzf protobuf-all-${PROTOBUF_VERSION}.tar.gz
cd protobuf-${PROTOBUF_VERSION}
./configure
make
make install
cd ..
ldconfig
protoc --version
rm -r protobuf-${PROTOBUF_VERSION}
rm -r protobuf-all-${PROTOBUF_VERSION}.tar.gz

#########################################################
#                      Clean                            #
#########################################################
apt autoremove --yes
apt clean
apt autoclean
rm -rf /tmp/*
rm -rf /var/log
rm -rf /var/tmp/*
rm -rf /var/cache
rm -rf /var/lib/apt/lists/*
rm -rf .cache
find / -type f -name "*.a" -exec rm -rf {} \;
