#########################################################
#                      Settings                         #
#########################################################
OS=ubuntu1604
NVIDIA_REPO="http://developer.download.nvidia.com/compute/cuda/repos/${OS}/x86_64"
NVIDIA_VERSION=418.67-0
NVIDIA_VERSION_MAJOR=${NVIDIA_VERSION%.*} # a.b-c -> a
NVIDIA_PACKAGE="nvidia-${NVIDIA_VERSION_MAJOR}_${NVIDIA_VERSION}ubuntu1_amd64.deb"
CUDA_VERSION=10.1.105-1
CUBLAS_VERSION=10_10.1.0.105-1
CUDA_VERSION_MAJOR_MINOR=${CUDA_VERSION%.*} # a.b.c-d -> a.b
CUDA_VERSION_CODE=${CUDA_VERSION_MAJOR_MINOR//./-} # a.b -> a-b
CUDA_PACKAGES=(
    "cuda-license-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "libcuda1-${NVIDIA_VERSION_MAJOR}_${NVIDIA_VERSION}ubuntu1_amd64.deb"
    "cuda-cufft-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "libcublas${CUBLAS_VERSION}_amd64.deb"
    "cuda-cudart-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "cuda-cusolver-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
    "cuda-curand-${CUDA_VERSION_CODE}_${CUDA_VERSION}_amd64.deb"
)
CUDNN_REPO=http://developer.download.nvidia.com/compute/machine-learning/repos/${OS}/x86_64
CUDNN_VERSION=7.6.5.32-1

#########################################################
#           Do not wait keyboard input                  #
#########################################################
export DEBIAN_FRONTEND=noninteractive

#########################################################
#                      Update                           #
#########################################################
apt-get update

#########################################################
#                 Install NVIDIA drivers                #
#########################################################
mkdir /usr/lib/nvidia
wget --quiet ${NVIDIA_REPO}/${NVIDIA_PACKAGE}
apt install --yes --fix-broken --no-install-recommends ./$NVIDIA_PACKAGE
rm -f $NVIDIA_PACKAGE

#########################################################
#                     Install CUDA                      #
#########################################################
for PACKAGE in ${CUDA_PACKAGES[*]}
do
    wget --quiet ${NVIDIA_REPO}/${PACKAGE}
    apt install --yes --fix-broken --no-install-recommends ./$PACKAGE
    rm -f $PACKAGE
done;

#########################################################
#                 Create CUDA symlimk                   #
#########################################################
ln -s /usr/local/cuda-${CUDA_VERSION_MAJOR_MINOR} /usr/local/cuda

#########################################################
#                      Install cuDNN                    #
#########################################################
wget --quiet ${CUDNN_REPO}/nvidia-machine-learning-repo-${OS}_1.0.0-1_amd64.deb
dpkg -i nvidia-machine-learning-repo-${OS}_1.0.0-1_amd64.deb
apt-get update
apt-get install --yes --fix-broken --no-install-recommends libcudnn7=${CUDNN_VERSION}+cuda${CUDA_VERSION_MAJOR_MINOR}
rm -f nvidia-machine-learning-repo-${OS}_1.0.0-1_amd64.deb

#########################################################
#                Configure dynamic linker               #
#########################################################
CUDA_CONF=/etc/ld.so.conf.d/cuda-${CUDA_VERSION_MAJOR_MINOR}.conf
echo /usr/local/cuda-${CUDA_VERSION_MAJOR_MINOR}/lib64 > "${CUDA_CONF}"
echo /usr/lib/x86_64-linux-gnu >> "${CUDA_CONF}"

NVIDIA_CONF=/etc/ld.so.conf.d/nvidia-${NVIDIA_VERSION_MAJOR}.conf
echo /usr/lib/nvidia-${NVIDIA_VERSION_MAJOR} > "${NVIDIA_CONF}"

ldconfig

#########################################################
#                      Clean                            #
#########################################################
apt autoremove --yes
apt clean
apt autoclean
rm -rf /tmp/*
rm -rf /var/log
rm -rf /var/tmp/*
rm -rf /var/cache
rm -rf /var/lib/apt/lists/*
rm -rf .cache
find / -type f -name "*.a" -exec rm -rf {} \;
