#### Инструмент для оценки качества детектирования зданий

Инструмент используется для оценки качества детектирования зданий. Для этого используется метрика качества intersection over union (IoU, https://en.wikipedia.org/wiki/Jaccard_index). Здание на снимке считается найденным, если среди результатов детектирования есть полигон, с которым значение IoU для этого здания больше некоторого порогового значения.

Качество работы оценивается по двум критериям:
* Доля найденных зданий (полнота, recall)
* Доля верно продетектированных зданий (точность, precision)
![Расчет метрик](https://jing.yandex-team.ru/files/dolotov-e/precision_recall.png)

**Пример использования**

Запуск с параметрами по умолчанию:

> ./quality_benchmark

При сборке инструмента с помощью ya make все необходимые данные для запуска оценки качества с параметрами по умолчанию будут автоматически загруженны в папку "data", которая располагается в папке с проектом.
Эти данные состоят из:
* Списка файлов (data/data_list.txt)
* Спутниковые снимки (data/images)
* Разметка домов на этих снимках (data/labels)
* Набор gdef файлов для нейронных сетей (data/*.gdef)

По умолчанию будет запущена проверка для метода "прямоугольниками" (detectBldByMinAreaRect). Для смены метода детектирования можно воспользоваться параметром mode:

> ./quality_benchmark --mode edge

Запуск на своих данных:

> ./quality_benchmark
> --mode rectangle
> --data_path my_data/
> --items_list_path data_list.txt
> --sem_segm_path my_networks/sem_segm.gdef
> --edge_detector_path my_networks/edge_detection.gdef
> --iou_threshold 0.6

Описание параметров:
* mode - метод детектирования зданий:
  * rectangle - метод, использующий семантическую сегментацию и детектор ребер
  * edge - метод, использующий только детектор ребер
  * edge_vert - метод, использующий семантическую сегментацию, детектор ребер и вершин
* data_path - путь до папки с данными для оценки качества
* items_list_path - путь до текстового файла со списком файлов, для которым необходимо оценить качество
* sem_segm_path - путь до файла с весами сети для семантической сегментации
* edge_detector_path - путь до файла с весами сети для детектирования ребер
* edge_vert_path - путь до файла с весами сети для детектирования ребер и вершин

