from algorithm import kneighbors
from algorithm import gradient

def align_angles(rects, method):
    """Align angles between rectangles.

    Args:
        rects (list): List of named tuples Rect with rectangles parameters.
            Rect = namedtuple('Rect', ['x', 'y', 'width', 'height', 'angle'])
        method (string): Name of algorithm for align angles. Choices = ['kneighbors', 'gradient']

    Returns:
        list: List of aligned rectangles in the following format: [(x, y), (w, h), angle].

    Raises:
        ValueError: If name of algorithm not in ['kneighbors', 'gradient'].
    """
    if method == "kneighbors":
        return kneighbors.align_angles(rects,
                                       n_neighbors = 3,
                                       angle_delta = 10.0, dist_delta = 200.0,
                                       iterations = 5)
    elif method == "gradient":
        return gradient.align_angles(rects,
                                     weight_threshold = 0.01, angle_delta = 10.0,
                                     angle_decay = 5.0,
                                     iterations = 100)
    else:
        raise ValueError("Unknown method: {}".format(method))
