import argparse
import numpy as np
import cv2
from angles import align_angles
import rectangles


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--image', default = None, help = "Path to image")
    parser.add_argument('--rectangles', required = True, help = "Path to text file with recntagles")
    parser.add_argument('--align_method', choices = ['kneighbors', 'gradient'], required = True, help = "Method of align angles")
    args = parser.parse_args()

    print("Load fectangles from file: {}".format(args.rectangles))
    rects = rectangles.load(args.rectangles)

    print("Align angles between rectangles with method: {}".format(args.align_method))
    aligned_rects = align_angles(rects, args.align_method)

    if args.image is None:
        canvas = np.zeros([1500, 1500], np.uint8)
        aligned_canvas = np.zeros([1500, 1500], np.uint8)
    else:
        image = cv2.imread(args.image)
        if image is None:
            raise ValueError("Failed to open image: {}".format(args.image))
        canvas = np.copy(image)
        aligned_canvas = np.copy(image)

    rectangles.draw(canvas, rects)
    rectangles.draw(aligned_canvas, aligned_rects)

    cv2.imshow("rectangles", canvas)
    cv2.imshow("aligned rectangles", aligned_canvas)
    cv2.waitKey()
    if args.image is not None:
        cv2.imwrite("{}_before.jpg".format(args.image[:-4]), canvas)
        cv2.imwrite("{}_after.jpg".format(args.image[:-4]), aligned_canvas)
        rectangles.save("{}_processed.txt".format(args.rectangles[:-4]), aligned_rects)


if __name__ == "__main__":
    main()
