# Инструмент для выравнивания углов между прямоугольниками

Для выравнивания доступно два метода:
1. Усреднение по ближайшим соседям
2. Оптимизация при помощи оптимизации функции потерь

## Выравнивание по ближайшим соседям
Данный метод заключается в следующем:
1. Для каждого прямоугольника находятся не более K ближайщих соседей (расстояние между прямоугольниками - расстояние между центрами), удовлетворяющих следующих условиям:
    1. Углы поворота соседей отличаются не более чем на *angle_delta* 
    2. Расстояние между цетрами соседей не более *dist_delta*
2. Новый угол поворота получается из усреднения угла поворота самого прямоугольника и всех его соседей.
3. Если необходимое количество итераций не было совершено, то повторяем действия 1 и 2.

## Выравнивание оптимизацией функции потерь
Данный метод заключается в следующем:
1. Составляется функция потерь. Функция потерь представляет собой взвешенную сумму квадратов разницы углов поворота для каждой пары прямоугольников, удовлетворяющей следующим условиям:
    1. Углы поворота отличаются не более чем на *angle_delta* 
    2. Вес между прямоугольниками превышает *weight_threshold*
2. Вес между прямоугольниками уменьшается с увеличением расстояния между прямоугольниками и равен 1/(dist(rect1, rect2)+1).
3. В функцию потерь добавляются штрафы за большое отклонение от начального угла.

## Примеры запуска
Для запуска с методом усреднения по соседям:
python post_processing --image img.jpg --rectangles rects.txt --align_method kneighbors
Для запуска с оптимизацией функции потерь:
python post_processing --image img.jpg --rectangles rects.txt --align_method gradient

При запуске без параметра *image* результат нарисуется на черном фоне.

### Описание файла с прямоугольниками
В качестве параметра rectangles падается путь до текстового файла с параметрами прямоугольников.
Каждому прямоугольнику соответствует одна строка файла. Параметры прямоугольника записываются  через пробел в следующем порядке: x координата центра, у координата центра, ширина, высота, угол поворота в градусах.

Пример файла с двумя прямоугольниками:
3 5 8 6 9
4 5 9 7 8

Первый прямоугольник имеет координаты центра (3, 5), ширину 8, высоту 6 и угол поворота 9 градусов.
Второй прямоугольник имеет координаты центра (4, 5), ширину 9, высоту 7 и угол поворота 8 градусов.


