#pragma once

#include "opencv2/core/core.hpp"
#include <vector>


namespace maps {
namespace wiki {
namespace autocart {

//       
struct ExtractVerticesParams
{
    ExtractVerticesParams()
        : m_minThreshold(0.2)
        , m_nmsCellSz(6)
    {}
    //        .    - ,
    //       (   0.  1.  
    //   8UC1)
    double m_minThreshold;
    //    non maximum suppression 
    int m_nmsCellSz;
};

//       
struct ExtractEdgesParams
{
    ExtractEdgesParams()
        : m_vertRad(1)
        , m_minWeightThreshold(0.35)
        , m_maxLength(100.)
        , m_minLength(5.)
    {}

    int m_vertRad;
    //     m_minWeightThreshold  
    double m_minWeightThreshold;
    //       m_minLength  m_maxLength
    double m_minLength;
    double m_maxLength;
};

//    (.  
//    double CoordGraph::weightCycle(const EdgesPath &cycle, const cv::Mat &segm, const WeightCycleParams &param) const)
struct WeightCycleParams
{
    WeightCycleParams()
        : m_smallAngleMax(30.)
        , m_smallAnglePenaltyEps(1e-2)
        , m_nonQuadPenalty(0.0)
        , m_segmAreaCoeff(0.3)
        , m_angleDeltaCoefPenalty(10.0)
        , m_minArea(500)
    {}

    //         m_smallAngleMax
    //        m_smallAnglePenalty
    double m_smallAngleMax;
    double m_smallAnglePenaltyEps;
    //         4-
    double m_nonQuadPenalty;

    //         90 
    double m_angleDeltaCoefPenalty;

    //      (    ) +
    //    ,       
    //      m_segmAreaCoeff -      
    double m_segmAreaCoeff;

    //     ( ),    
    int m_minArea;
};

//  ""    
struct BestCycleParams
{
    BestCycleParams()
        : m_minCycleWeight(0.3)
        , m_minIntersectionArea(300)
        , m_minRelativeIntersectionArea(0.2)
        , m_newEdgesPercent(0.5)
    {}
    //      m_minCycleWeight     
    double m_minCycleWeight;

    //          m_minIntersectionArea ( ),
    //   Best   
    int m_minIntersectionArea;

    //           ,  
    // m_minRelativeIntersectionArea,   Best   
    double m_minRelativeIntersectionArea;

    //  ""    ,    
    double m_newEdgesPercent;
};

struct ThinPolygonsParams
{
    ThinPolygonsParams()
        : m_maxVertEdgeDist(6.)
        , m_leftRange(0.1)
        , m_rightRange(0.9)
    {}

    //   0.0     (..        
    // m_maxVertEdgeDist,   )
    double m_maxVertEdgeDist;

    //       ,       
    //      ,     
    double m_leftRange;
    double m_rightRange;
};

struct ExtractPolygonsParams
{
    ExtractPolygonsParams()
        : m_extractLevelsCount(4)
        , m_keenVerticesMaxAngle(15.)
        , m_removeIntersectEdges(true)
    {}
    ExtractVerticesParams m_vertsParams;
    ExtractEdgesParams m_edgesParams;

    int m_extractLevelsCount;

    //   0.0    (       m_keenVerticesMaxAngle)
    //     0.0        (..   0  1 )
    double m_keenVerticesMaxAngle;
    //     
    bool m_removeIntersectEdges;

    ThinPolygonsParams m_thinPolygonsParams;
    WeightCycleParams m_weightCycleParams;
    BestCycleParams m_bestCycleParams;
};

bool extractPolygons(const cv::Mat &vertData, const cv::Mat &edgeData, const cv::Mat &segm_data, const ExtractPolygonsParams &params, std::vector< std::vector<cv::Point> > &polygons);

} //namespace autocart
} //namespace wiki
} //namespace maps
