#pragma once

#include "opencv2/core/core.hpp"
#include <vector>


namespace maps {
namespace wiki {
namespace autocart {

struct PPPolygonsParams
{
    PPPolygonsParams()
        : m_nearStraightMaxDelta(45. * CV_PI / 180)
        , m_smallEdgesMaxDist(10.)
        , m_rectifyQuadToRectByEdge(false)
        , m_rectifyAnglesToOrthoMaxDelta(15. / 180. * CV_PI)
        , m_removeAcuteAngleMax(45. / 180. * CV_PI)
        , m_thinRectMinFraction(0.2)
        , m_thinRectMinLength(15.)
    {}

    double m_nearStraightMaxDelta;
    double m_smallEdgesMaxDist;
    bool m_rectifyQuadToRectByEdge;
    double m_rectifyAnglesToOrthoMaxDelta;
    double m_removeAcuteAngleMax;
    double m_thinRectMinFraction;
    double m_thinRectMinLength;
};

void postprocessPolygons(const PPPolygonsParams &params, std::vector<std::vector<cv::Point> > &polygons);
} //namespace autocart
} //namespace wiki
} //namespace maps
