#pragma once

#include "opencv2/core/core.hpp"

namespace maps {
namespace wiki {
namespace autocart {
/**
* To find orientation of ordered triplet (p, q, r).
* The function returns following values
* 0 --> p, q and r are colinear
* 1 --> Clockwise
* 2 --> Counterclockwise
*/
int orientation(const cv::Point &a, const cv::Point &b, const cv::Point &c);
bool isSegmentIntersect(const cv::Point &segm1s, const cv::Point &segm1e, const cv::Point &segm2s, const cv::Point &segm2e);
//   v1 -- c -- v2
double calcAngle(const cv::Point &v1, const cv::Point &c, const cv::Point &v2);
//    90  
double deltaAngle(double angle);
//    pt   segms -- segme
//  false,      
bool projectPointOnSegment(const cv::Point &pt, const cv::Point &segms, const cv::Point &segme, cv::Point &result);
bool projectPointOnSegment(const cv::Point2d &pt, const cv::Point2d &segms, const cv::Point2d &segme, cv::Point2d &result);
//   -  -   ( Y  )
bool isClockwise(const std::vector<cv::Point> &polygon);
void makeRectangle(const cv::Point &base, double angle, double edgeLen0, double edgeLen1, int orient, std::vector<cv::Point> &polygon);
} //namespace autocart
} //namespace wiki
} //namespace maps
