#pragma once
#include <maps/wikimap/mapspro/libs/tf_inferencer/tf_inferencer.h>
#include <opencv2/opencv.hpp>
#include <vector>

#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/spatial_relation.h>
#include <maps/libs/geolib/include/intersection.h>
#include <maps/libs/geolib/include/vector.h>
#include <maps/libs/geolib/include/distance.h>
#include <maps/libs/geolib/include/convex_hull.h>
#include <maps/libs/geolib/include/segment.h>
#include <maps/libs/geolib/include/line.h>
#include <maps/libs/geolib/include/direction.h>
#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/static_geometry_searcher.h>

namespace maps {
namespace wiki {
namespace autocart {

/**
 * @brief detects roads on sattelite image
 * @param image -- sattelite image to detect roads on
 * @return container with detected polylines
 */
std::vector<geolib3::Polyline2>
detectRoad(const tf_inferencer::TensorFlowInferencer &roadDetector,
           const cv::Mat &image);

} //namespace autocart
} //namespace wiki
} //namespace maps
