exports.Task = extend(TolokaHandlebarsTask, function (options) {
  this._inputs = options.task.input_values;

  TolokaHandlebarsTask.call(this, options);

  this.mapId = _.uniqueId('map');
}, {
        getTemplateData: function() {
		    var data = TolokaHandlebarsTask.prototype.getTemplateData.apply(this, arguments);
			data.mapId = this.mapId;
			return data;
		},

        validate: function (solution) {
            var output = solution.output_values;
            if (!output.state) {
                return {
                    task_id: this.getTask().id,
                    errors: {
                        state: {
                            code: 'NOT_ALLOWED',
                            message: 'Необходимо классифицировать изображение!'
                        }
                    }
                };
            } else if (output.state == "yes"){
                if (!output.ft_type_id) {
                    return {
                        task_id: this.getTask().id,
                        errors: {
                            ft_type_id: {
                                code: 'NOT_ALLOWED',
                                message: 'Необходимо определить тип здания!'
                            }
                        }
                    };
                }
                if (!output.height) {
                    return {
                        task_id: this.getTask().id,
                        errors: {
                            height: {
                                code: 'NOT_ALLOWED',
                                message: 'Необходимо определить высоту здания!'
                            }
                        }
                    };
                } else if (!isCorrectHeight(output.height)) {
                    return {
                        task_id: this.getTask().id,
                        errors: {
                            height: {
                                code: 'NOT_ALLOWED',
                                message: 'Некорректное значение высоты здания!'
                            }
                        }
                    };
                }
            }
      	    return null;
        },

        onValidationFail: function (data) {
            TolokaHandlebarsTask.prototype.onValidationFail.apply(this, arguments);
        },
        onRender: function() {
            var _this = this;
		    var polygon = this.getTask().input_values.polygon;
			ymaps.ready(init);

			function init() {
				var center_lat = 0.;
				var center_lon = 0.;
                var rev_polygon = []
				for (var i = 0; i < polygon.length; i++) {
                    center_lat += polygon[i][1];
                    center_lon += polygon[i][0];
                    rev_polygon.push([polygon[i][1], polygon[i][0]]);
				}
				center_lat /= polygon.length;
				center_lon /= polygon.length;
                var map_center = [center_lat, center_lon];
				var myMap = new ymaps.Map(_this.mapId, {
					center: map_center,
					zoom: 18,
					type: 'yandex#hybrid',
					controls: ['zoomControl']
				}, {
					searchControlProvider: 'yandex#search'
				});

                myMap.layers.add(new ymaps.Layer('//0%d.core-nmaps-renderer-nmaps.maps.yandex.net/tile?%c&l=mpskl&sl=104,210342,210370,210416,211777,211818,2118180,211939,211977,211993,212015,212017,212019,212026,212032,212053,212081,212094,212216,300024,300026,300170,300198,300207,300224,300231,300270,300292,300330,300337,300344,300351,300358,300365,300372,300379,300386,300393,300400,300406,300407,300447,300468,300472,300523,300641,300651,300661,300671,300683,300931,300939,300954,300969,300993,301050,301084,301125,301135,301142,301338,301352,301360,301596,301701,302053,302080,302089,302090,302107,302526,5300026,5400046,5400051,5400060,5400076,700010001,700010157,70300149,70300190,70300482,70300608,70300627', {
                    projection: ymaps.projection.wgs84Mercator
                }));

                myMap.behaviors.disable(['drag', 'scrollZoom', 'dblClickZoom', 'multiTouch', 'rightMouseButtonMagnifier','leftMouseButtonMagnifier', 'ruler', 'routeEditor']);

				var myPolygon = new ymaps.Polygon([
					rev_polygon
                ], {
                    hintContent: "Здание"
                }, {
                    fill: false,
                    strokeColor: '#FF0000',
                    strokeWidth: 7
                });
                myMap.geoObjects.add(myPolygon);
    		}

            var coordinates = $(this.getDOMElement()).find('.coordinates');
            var polygon = this._inputs.shape;
            coordinates[0].textContent += polygon[0][1] + ", " + polygon[0][0];
            coordinates[0].href += polygon[0][0] + ", " + polygon[0][1];
      
            var attributes = $(this.getDOMElement()).find('.attributes')[0];

            var showAttributes = function() {
                attributes.style.display = 'block'
            }
            var hideAttributes = function() {
                attributes.style.display = 'none'
            }
        
            var output_values = this.getSolution().output_values
            if (output_values.state) {
                if (output_values.state == 'yes') {
                    showAttributes(); 
                } else {
                    hideAttributes();
                }
            }
      
            var yesRadio = $(this.getDOMElement()).find('.yes')[0];
            yesRadio.onclick = showAttributes
            var noRadio = $(this.getDOMElement()).find('.no')[0];
            noRadio.onclick = hideAttributes
            var notloadedRadio = $(this.getDOMElement()).find('.not-loaded')[0];
            notloadedRadio.onclick = hideAttributes
        }
});

function isCorrectHeight(str) {
    var n = Math.floor(Number(str));
    return n !== Infinity && String(n) === str && n >= 0 && n <= 50;
}

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
