**Обучение автоматического валидатора результатов детектирования зданий**

Из результатов детектирования можно получить спутниковый снимок, а также маску предполагаемого здания.

Имеея эту информацию, а также ответы от исполнителей в Я.Толоке, можно попробовать обучить сеть, которая будет валидировать результаты детектирования.

![Общая идея](https://jing.yandex-team.ru/files/dolotov-e/quality.png)

На **вход** сети подается трехканальный спутниковый снимок и одноканальная маска здания.

На **выходе** получается ответ - хорошее это здание или нет.

Перед запуском обучения необходимо закачать данные:
1) auto_toloker/dataset_loader - скачивает из YT полигоны домов и ответы толокеров
2) auto_toloker/image_and_mask_loader - скачивает спутниковые снимки и русует маски
3) auto_toloker/to_tfrecord - преобразует данные в формат TFRecord

Далее необходимо собрать проект:
Для *CPU*:
> ya make -r --checkout

Для *GPU*:
> ya make -r --checkout -DTENSORFLOW_WITH_CUDA=1 -DCUDA_VERSION=9.1

Описать конфигурацию обучения в json файле. Пример лежит в папке cfg.

Запуск обучения выполняется следующей командой:
Локально:
> ./train --train_config cfg/config.net.json --environment local

В Нирване:
> ./train --train_config cfg/config.net.json --environment nirvana

При запуске в Нирване снапшоты будут архивироваться и закачиваться в нужные выходы

Структура кода:

* **__main__.py** - описывает основной цикл обучения
* **utils/config.py** - работа с конфигурационными файлами в json
* **utils/dataset.py** - работа с данными в tfrecord
* **utils/snapshot.py** - сохранение и загрузка сетей
* **nets/models** - папка с различными вариантами сетей
* **nets/nets_factory.py** - возвращает нужную сеть по заданному имени
* **nets/train_utils.py** - описывает функцию ошибку и алгоритм оптимизации
* **samples/cfg** - папка с конфигурациями обучения
