#pragma once
#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/bounding_box.h>

#include <pqxx/transaction_base>
#include <list>

namespace maps::mrc::semgen {

struct Building : public geolib3::Polygon2 {
    Building(const geolib3::Polygon2& roof)
        : geolib3::Polygon2(roof) {}
    Building(const geolib3::Polygon2& footprint,
             const std::optional<double>& height)
        : geolib3::Polygon2(footprint),
          height(height) {}
    // building height in meters
    std::optional<double> height;
};
using Vegetation = geolib3::Polygon2;
using Hydro = geolib3::Polygon2;
using Road = geolib3::Polyline2;

class MapsLoader {
public:
    /**
     * @param bbox -- in mercator coordinates
     */
    MapsLoader(pqxx::transaction_base& txn,
               const geolib3::BoundingBox& bbox)
        : txn_(txn)
        , bbox_(bbox)
    {}

    virtual std::list<Building> loadBuildings() const = 0;

    virtual std::list<Vegetation> loadVegetation() const = 0;

    virtual std::list<Hydro> loadHydro() const = 0;

    virtual std::list<Road> loadRoads() const = 0;
protected:
    pqxx::transaction_base& txn_;
    geolib3::BoundingBox bbox_;
};

} // namespace maps::mrc::semgen
