#pragma once
#include "maps_reader.h"

#include <maps/libs/geolib/include/bounding_box.h>
#include <pqxx/transaction_base>

#include <list>

namespace maps::mrc::semgen {

class YMapsDFLoader : public MapsLoader {
public:
    /**
     * @param bbox -- in mercator coordinates
     */
    YMapsDFLoader(pqxx::transaction_base& txn,
                  const geolib3::BoundingBox& bbox)
        : MapsLoader(txn, bbox)
    {}

    virtual std::list<Building> loadBuildings() const;

    virtual std::list<Vegetation> loadVegetation() const;

    virtual std::list<Hydro> loadHydro() const;

    virtual std::list<Road> loadRoads() const;
};

} // namespace maps::mrc::semgen
