**Структура сети**

![Структура сети HED](https://jing.yandex-team.ru/files/dolotov-e/hed_edges_verts.png)

Для нахождения ребер и вершин домов используется сеть, описанная в статье Holistically-Nested Edge Detection (HED, https://arxiv.org/pdf/1504.06375.pdf).

Сеть HED состоит из 5 стадий со свертками (аналогичных VGG16). К последней свертке на каждой стадии добавляются две ветки: одна для вершин, вторая для ребер. Каждая ветка состоит из свертки с ядром 1х1х1 и слоя, выполняющего масштабирование до размера исходного изображения (бикубическая интерполяця или deconvolution слой с обучаемыми параметрами).

Результат каждой такой свертки масштабируется до размера исходного изображения (бикубической интерполяцией или deconvolution слоями с обучаемыми параметрами)

Общая ошибка сети - сумма ошибок на всех ветках. Ошибка на одной ветке считается следующим образом:

![Функция ошибки](https://jing.yandex-team.ru/files/dolotov-e/loss_function.png)

#### Подготовка данных
Для обучения сети необходимо иметь следующие данные:
* Спутниковые снимки
* Разметку с полигонами домов

##### Скачивание данных
Для получения этих данных можно возпользоваться инструментом autocart/tools/ymapsdf_semseg_dataset_generator
Пример использования:
> ./ymapsdf_semseg_dataset_generator \
> --tile-source 'http://core-sat-internal.maps.yandex.net/tiles'  \
> --bbox '28.77,40.98~28.95,41.10'  \
> --zoom 18  \
> --connstr "dbname=garden host=garden-pgm-rus01h.tst.maps.yandex.ru user=mapsgarden password=gardenTst port=5432 options=--search_path=public,ymapsdf_yandex_and_tr_20171029_008718_17_7456629a"

**tile-source** - источник спутниковых снимков
**bbox** - координаты области
**zoom** - масштаб
**connstr** - параметры доступа к базе с разметкой. Актуальную информация можно посмотреть [здесь](https://garden.tst.maps.yandex-team.ru/). Необходимо смотреть строки со статусом 'completed'. Регион России - 'Russia', регион Турции - 'And Tr'

Результатом выполнения программы будут являться два файла:
* output.jpg - спутниковый снимок
* output.txt - разметка домов, дорог и т.д.

##### Растеризация разметки
Полученную разметку необходимо растеризовать.
Для этого можно воспользоваться инструментов autocart/tools/cnn_semseg_dataset_rasterizer

#### Запуск обучения

##### Локальный запуск
Для локального запуска обучения сети необходимо следующее:

* Создать папку **data** с обучающими данными.
* Прописать имена файлов с изображениями и разметкой в переменные окружения YTF_DATASET_IMAGE_FILENAME, YTF_DATASET_EDGES_FILENAME, YTF_DATASET_VERTS_FILENAME в файле run_local_train.sh
* Указать другие параметры обучения в run_local_train.sh
* Запустить run_local_train.sh

##### Запуск на нирване
Для запуска обучения на нирване необходимо выполнить следующие действия:

* Загрузить в нирвану архив с изображениями, указав при этом тип данных **Image**.
* Загрузить в нирвану архив с разметкой, указав при этом тип данных **Text**.
* Подать на вход [операции](https://nirvana.yandex-team.ru/operation/e500fbe9-9c3e-48a7-bb51-fd05f9af8c26/overview) два этих архива, указать в опциях операции необходимые параметры обучения, запустить выполнение графа.

Для просмотра логов в tensorboard необходимо выполнить следующий запрос:
https://tensorboard.nirvana.yandex-team.ru/api/board/createFromNirvana?instanceId=**instanceId**&blockCode=**blockCode**&endpointName=logs

**instanceId** можно узнать во вкладке **Details** в поле Workflow Instance (пример 9233a2e6-93cd-4c7b-9c89-48d98919bdcb)

**blockCode** код блока можно узнать во вкладке **Details** в поле Local ID (пример operation-1523961991714-11)

