#!/bin/sh -ex

# Image params
export YTF_IMAGE_WIDTH=64
export YTF_IMAGE_HEIGHT=64
export YTF_DATASET_SUBFOLDER=""
export YTF_DATASET_IMAGE_FILENAME="images.dat"
export YTF_DATASET_SEGM_FILENAME="segm.dat"
# Loss function
export YTF_CLASSES_CNT=2
export YTF_TRAINER_LOSS_FUNCTION="IoU"
# export YTF_LOSS_WEIGHTS=
export YTF_VOID_CLASS_EXISTS=1
# Optimizer params
export YTF_TRAINER_OPTIMIZER="AdamOptimizer"
export YTF_TRAINER_LR_BASE=0.001
export YTF_TRAINER_LR_DECAY_EPOCH=25
export YTF_TRAINER_LR_DECAY_RATE=0.3
export YTF_TRAINER_LR_DECAY_STAIRCASE=1
export YTF_TRAINER_BATCH_SIZE_PER_GPU=1
export YTF_TRAINER_WEIGHT_DECAY=0.0001
export YTF_TRAINER_EPOCH_START=0
export YTF_TRAINER_EPOCH_MAX=200
# Data augmentation
export YTF_EQUALIZE_HIST_ENABLE=1
export YTF_ENABLE_DATA_AUGMENTATION=1
export YTF_ENABLE_REMOVE_EMPTY_CELL=1
export YTF_DATA_SPLIT_SEED=42
# Inference inputs and outputs
export YTF_INFERENCE_INPUT="inference_input"
export YTF_CLASS_PROB_OUTPUT="inference_softmax"
export YTF_CLASS_INDX_OUTPUT="inference_argmax"
# Validate params
export YTF_VALIDATE_BATCH_CNT=5
# Output params
export YTF_MODEL_OUTPUT_FOLDER="./model-data"
export YTF_LOGS_OUTPUT_FOLDER="./logs"
export YTF_TRAINER_SAVE_EVERY_EPOCHES=25
export YTF_SNAPSHOT_OUTPUT_FOLDER="./snapshot"
# Run train
python ./train.py

