#pragma once

#include <yandex/maps/wiki/mds_dataset/types.h>
#include <maps/infra/yacare/include/yacare.h>

#include <boost/lexical_cast.hpp>

#include <string>

namespace maps {
namespace wiki {

namespace dataset_explorer {

template <class T>
boost::optional<T> getOptionalParam(
    const yacare::Request& request,
    const std::string& name)
{
    std::string strParam = request.input()[name];
    if (strParam.empty()) {
        return boost::none;
    }
    try {
        return boost::lexical_cast<T>(strParam);
    }
    catch (const boost::bad_lexical_cast&) {
        throw yacare::errors::BadRequest() << "Invalid parameter: " << name;
    }
}

template <class T>
T getParam(
    const yacare::Request& request,
    const std::string& name,
    const T& defaultVal)
{
    auto param = getOptionalParam<T>(request, name);
    return param ? *param : defaultVal;
}

template <class T>
T getParam(const yacare::Request& request, const std::string& name)
{
    auto value = getOptionalParam<T>(request, name);
    if (!value) {
        throw yacare::errors::BadRequest() << "Missing parameter: " << name;
    }
    return *value;
}

} // namespace dataset_explorer
} // namespace wiki
} // namespace maps
