#pragma once

#include "acl_utils.h"
#include "moderation.h"

namespace maps::wiki::moderation {

const std::string AUTO_FLAG = "auto";
const std::string NOT_FLAG = "not";

struct AclRoleNameParts;

class AclRoleInfo {
public:
    explicit AclRoleInfo(std::string aclRoleName);

    const std::string& roleName() const;
    TrustLevel trustLevel() const;
    const StringSet& categoryGroupIds() const;
    bool canProcessAllGroups() const;
    bool hasAccessToCommonTasks() const;
    bool isAuto() const;
    bool canProcessCategory(const std::string& categoryId) const;

private:
    void setTrustLevel(const AclRoleNameParts& aclRoleNameParts);
    void setCategoryGroupIds(const AclRoleNameParts& aclRoleNameParts);
    void setCanProcessAllGroups(const AclRoleNameParts& aclRoleNameParts);
    void setHasAccessToCommonTasks(const AclRoleNameParts& aclRoleNameParts);

    std::string aclRoleName_; // Original name
    std::string roleName_;

    TrustLevel trustLevel_;
    StringSet categoryGroupIds_;
    bool canProcessAllGroups_;
    bool hasAccessToCommonTasks_;
    bool isAuto_;
};

} // namespace maps::wiki::moderation
