#include "acl_utils.h"
#include "branch_helpers.h"
#include "configs/config.h"
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/acl/include/exception.h>

namespace maps::wiki {

namespace {

acl::User getUser(pqxx::transaction_base& txnCore, TUid uid)
{
    return acl::ACLGateway(txnCore).user(uid);
}

} // namespace

acl::User getUser(const BranchContext& branchCtx, TUid uid)
{
    return getUser(branchCtx.txnCore(), uid);
}

void checkUserActiveStatus(const BranchContext& branchCtx, TUid uid)
{
    getUser(branchCtx, uid).checkActiveStatus();
}

StringSet userGroups(TUid uid, const Token& token)
{
    if (!uid) {
        return {};
    }
    StringSet groups;
    try {
        auto work = cfg()->poolCore().slaveTransaction(token);
        auto user = getUser(*work, uid);
        user.checkNotDeletedStatus();
        for (const auto& group : user.groups()) {
            groups.insert(group.name());
        }
    } catch ( const acl::ACLException& ex) {
        WARN() << "Exception while accessing user acl groups: " << ex.what();
    }
    return groups;
}

} // namespace maps::wiki
