#include "get.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/check_permissions.h>

namespace maps {
namespace wiki {

GetBranches::GetBranches(const Request& request)
    : controller::BaseController<GetBranches>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{}

std::string
GetBranches::printRequest() const
{
    std::stringstream ss;
    ss << " uid: " << request_.uid;
    ss << " token: " << request_.token;
    return ss.str();
}

void
GetBranches::control()
{
    auto work = cfg()->poolCore().slaveTransaction(request_.token);
    result_->branches = loadHeadBranches(*work);
    if (!request_.uid ||
        !CheckPermissions(request_.uid, *work)
            .isUserHasAccessToViewBranches())
    {
        auto& branches = result_->branches;
        branches.erase(
            std::remove_if(
                branches.begin(),
                branches.end(),
                [](const auto& branch) {
                    return branch.type() != revision::BranchType::Trunk;
                }),
            branches.end());
    }
}

} // namespace wiki
} // namespace maps
