#pragma once
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>

namespace maps {
namespace wiki {


class ObserverCollection;
class SaveBranchState;
template<>
struct controller::ResultType<SaveBranchState>
{
    Branches branches;
    Token token;
};

class SaveBranchState: public controller::BaseController<SaveBranchState>
{
public:
    struct Request
    {
        std::string dump() const;
        TUid userId() const { return user; }

        const TUid user;
        const revision::BranchState branchState;
        const TBranchId branchId;
    };

    SaveBranchState(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
