#pragma once
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>

namespace maps {
namespace wiki {


class ObserverCollection;
class SaveBranchType;
template<>
struct controller::ResultType<SaveBranchType>
{
    Branches branches;
    Token token;
};

class SaveBranchType: public controller::BaseController<SaveBranchType>
{
public:
    struct Request
    {
        Request(
            TUid user,
            const std::string& branchTypeStr,
            TBranchId branchId);

        std::string dump() const;
        TUid userId() const { return user; }

        const TUid user;
        const revision::BranchType branchType;
        const TBranchId branchId;
    };

    SaveBranchType(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    void publishBranch();
    void deleteBranch();

    const Request request_;
};

} // namespace wiki
} // namespace maps
