#include "business_photos.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/check_permissions.h>

#include <sstream>

namespace maps::wiki {

namespace {

const std::string TASK_METHOD_NAME = "BusinessPhotos";

} // namespace

BusinessPhotos::BusinessPhotos(const Request& request)
    : controller::BaseController<BusinessPhotos>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
BusinessPhotos::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
BusinessPhotos::Request::dump() const
{
    std::stringstream ss;
    ss << " permalink: " << permalink;
    ss << " user: " << uid;
    return ss.str();
}

std::string
BusinessPhotos::printRequest() const
{
    return request_.dump();
}

void
BusinessPhotos::control()
{
    auto workCore = cfg()->poolCore().slaveTransaction();
    CheckPermissions(
        request_.uid,
        *workCore).checkAccessToBusinessPhotosTool();
    auto workSocial = cfg()->poolSocial().slaveTransaction();
    auto query =
        "SELECT photo_id FROM sprav.permalink_photo_view WHERE permalink_id = " +
        workSocial->quote(request_.permalink);
    auto rows = workSocial->exec(query);

    std::vector<std::string> photoIds;
    photoIds.reserve(rows.size());
    for (const auto& row : rows) {
        photoIds.push_back(row[0].as<std::string>());
    }
    result_->photoIds = photoIds;
}

} // namespace maps::wiki
