#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <string>
#include <vector>

namespace maps::wiki {

class BusinessPhotos;
template<> struct controller::ResultType<BusinessPhotos>
{
    std::vector<std::string> photoIds;
};

class BusinessPhotos: public controller::BaseController<BusinessPhotos>
{
public:
    struct Request
    {
        std::string dump() const;

        std::string permalink;
        TUid uid;
    };

    explicit BusinessPhotos(const Request& request);

    virtual ~BusinessPhotos() {}

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace maps::wiki
