#pragma once
#include "geom_diff.h"

#include "maps/wikimap/mapspro/services/editor/src/objects/object.h"
#include "maps/wikimap/mapspro/services/editor/src/objects_cache.h"

#include <yandex/maps/wiki/revision/diff.h>
#include <yandex/maps/wiki/revision/objectrevision.h>


namespace maps {
namespace wiki {

const size_t SLAVES_LIMIT_MULTIPLIER = 3;

class CommitDiffDataProvider
{
public:
    CommitDiffDataProvider(
            const std::unique_ptr<ObjectsCache>& prevCache,
            ObjectsCache& curCache,
            const boost::optional<revision::CommitDiff>& commitDiff);

    // Get objects category
    const Category& objectCategory(TOid oid) const;

    // Tell if objects are slave and master
    bool isSlaveOf(TOid slaveOid, TOid oid) const;

    // Tell if objects are slave and master indirectly
    bool isIndirectSlaveOf(TOid slaveOid, TOid oid) const;
    // Ids of objects directly modified by commit
    TOIds geomModifiedObjects() const;
    // Data for added and removed relations for commit
    std::vector<RelData> modifiedRelations() const;
    // Geometry before commit, if any
    Geom oldGeometry(TOid oid) const;
    // Geometry after commit, if any
    Geom newGeometry(TOid oid) const;
    // Ids of slaves with geometry
    TOIds objectGeomSlaves(TOid oid) const;

private:
    const std::unique_ptr<ObjectsCache>& prevCache_;
    ObjectsCache& curCache_;
    const boost::optional<revision::CommitDiff>& commitDiff_;

};


} // namespace wiki
} // namespace maps
