#pragma once

#include "geom_diff.h"
#include "thread_stop_diff.h"
#include "maps/wikimap/mapspro/services/editor/src/revisions_facade.h"
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"

#include <yandex/maps/wiki/revision/diff.h>

namespace maps {
namespace wiki {

struct DiffDetails
{
    geos::geom::Envelope envelope;

    ObjectPtr fromObjectVersion;
    ObjectPtr toObjectVersion;

    const ObjectPtr& anyObject() const
    {
        return fromObjectVersion && !categoryDiff
            ? fromObjectVersion
            : toObjectVersion;
    }

    bool hasErrors() const;
    boost::optional<revision::StringDiff> categoryDiff;
    revision::AttributesDiff attributesDiff;

    RoleToRelativesIdsDiff slavesDiff;
    RoleToRelativesIdsDiff mastersDiff;
    std::map<TOid, views::ViewObject> removedRelatives;
    std::map<TOid, views::ViewObject> addedRelatives;

    GeomDiff geomDiff;

    boost::optional<ThreadStopDiff> threadStopDiff;
};

void fillCategoryDiff(DiffDetails& details);

} // namespace wiki
} // namespace maps
