#pragma once

#include "diff_details.h"
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps {
namespace wiki {

class GetBranchDiff;

template<>
struct controller::ResultType<GetBranchDiff>
{
    TOid objectId;
    TBranchId fromBranchId;
    TBranchId toBranchId;

    DiffDetails details;
};

class GetBranchDiff: public controller::BaseController<GetBranchDiff>
{
public:
    struct Request
    {
        TOid objectId;
        TBranchId fromBranchId;
        TBranchId toBranchId;
        TUid user;
        Token dbToken;
    };

    explicit GetBranchDiff(const Request& request);

    virtual ~GetBranchDiff();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
