#pragma once

#include "diff_details.h"
#include "maps/wikimap/mapspro/libs/controller/include/basecontroller.h"
#include "maps/wikimap/mapspro/services/editor/src/commit.h"

namespace maps {
namespace wiki {

class ObjectsCache;
class GetCommitDiff;

template<>
struct controller::ResultType<GetCommitDiff>
{
    std::unique_ptr<CommitModel> commitModel;
    boost::optional<DiffDetails> details;
    std::string categoryId;
};

class GetCommitDiff: public controller::BaseController<GetCommitDiff>
{
public:
    struct Request
    {
        TCommitId commitId;
        TOid objectId;
        TUid user;
        Token dbToken;
        TBranchId branchId;
    };

    explicit GetCommitDiff(const Request& request);

    virtual ~GetCommitDiff();

    virtual std::string printRequest() const;

protected:
    virtual void control();

    void calcModified(RevisionsFacade& revisionsFacade,
        ObjectsCache& cache,
        TBranchId branchId);

private:
    Request request_;
};

} // namespace wiki
} // namespace maps
